<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class License extends Model 
{

    protected $table = 'licenses';
    public $timestamps = false;
    protected $fillable = array('max_account', 'id_customer', 'id_license_kind', 'id_validity_date');
    protected $visible = array('max_account', 'id_customer', 'id_license_kind', 'id_validity_date');

    public function licenseKind()
    {
        return $this->hasOne('LicenseKind', 'id_license_kind');
    }

    public function customer()
    {
        return $this->hasOne('Customer', 'id_customer');
    }

    public function validty_date()
    {
        return $this->hasOne('ValidityDate', 'id_license');
    }

}